import { Request, Response } from 'express';
import { kycService } from './service';

export const kycController = {
  // POST /kyc/submit
  async submit(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { data, error } = await kycService.submitKYC(vendor.id, req.body);
    if (error) return res.status(400).json({ error: error.message });
    return res.status(201).json({ success: true, data });
  },

  // GET /kyc/status
  async status(req: any, res: Response) {
    const vendor = req.vendor;
    if (!vendor) return res.status(401).json({ error: 'Unauthorized' });
    const { data, error } = await kycService.getKYCStatus(vendor.id);
    if (error) return res.status(404).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // GET /admin/kyc/pending
  async adminListPending(req: any, res: Response) {
    const admin = req.admin;
    if (!admin) return res.status(401).json({ error: 'Unauthorized' });
    const { limit = 20, offset = 0 } = req.query;
    const { data, error } = await kycService.listPendingKYC(Number(limit), Number(offset));
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  },

  // POST /admin/kyc/:vendorId/review
  async adminReview(req: any, res: Response) {
    const admin = req.admin;
    if (!admin) return res.status(401).json({ error: 'Unauthorized' });
    const { vendorId } = req.params;
    const { data, error } = await kycService.reviewKYC(vendorId, req.body, admin.id);
    if (error) return res.status(400).json({ error: error.message });
    return res.json({ success: true, data });
  }
}; 